import React from 'react'
import propTypes from 'prop-types'
import {
	EavisDatoPagesContainer,
	EavisDatoPage,
	EavisDatoPageLink,
	EavisDatoPageImage,
} from './index'
import { GetIssuePageLink, GetPaywallURL } from './functions'

const EavisDatoPages = ({ date, pages, catalog, loggedIn, type }) => {
	const arrayOfPages = []
	const linkType = type === 'dagbladet' ? 'dagbladet' : 'dagbladetmagasiner'
	for (let p = 2; p <= pages; p++) {
		const url = `//www.e-pages.dk/${linkType}/${catalog}/pic/tm${p}.jpg?xx`
		arrayOfPages.push(
			<EavisDatoPage key={p}>
				<EavisDatoPageLink href={loggedIn ? GetIssuePageLink(date, p, type) : GetPaywallURL()}>
					<EavisDatoPageImage src={url} alt="" />
				</EavisDatoPageLink>
			</EavisDatoPage>,
		)
	}
	return <EavisDatoPagesContainer>{arrayOfPages}</EavisDatoPagesContainer>
}

EavisDatoPages.propTypes = {
	pages: propTypes.number,
	catalog: propTypes.number,
	date: propTypes.string.isRequired,
	loggedIn: propTypes.bool,
	type: propTypes.string.isRequired,
}
EavisDatoPages.defaultProps = {
	pages: null,
	catalog: null,
	loggedIn: false,
}

export default EavisDatoPages
