import React from 'react'
import dynamic from 'next/dynamic'
import styled, { withTheme } from 'styled-components'
import { Col } from '@aller/shiny/src/atoms/Col'
import { SmallHeading } from '@aller/shiny/src/atoms/Heading'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

import CalmGrid from './CalmGrid'
import A from './A'
import Ul from './Ul'
import Li from './Li'
import Aside from './Aside'
import CenterHeading from './CenterHeading'
import HeaderCol from './HeaderCol'

const DinsideLogo = dynamic(() =>
	import(/* webpackChunkName: "DinsideLogo" */ '@aller/shiny/src/atoms/DinsideLogo').then(
		c => c.DinsideLogo,
	),
)

const InlineLogo = styled.div`
	display: inline-block;
	width: 10rem;
	margin: calc(${getVariable('uiRegularSize')} * 2);
`

const DinSideToolbox = () => (
	<CalmGrid>
		<Aside className="toolbox">
			<HeaderCol xs={12} center>
				<CenterHeading>
					<InlineLogo>
						<DinsideLogo /> Verktøykasse
					</InlineLogo>
				</CenterHeading>
			</HeaderCol>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Bolig</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/112377/dinsides-bolig-abc">Bolig-ABC</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/13263/eie-elle-leie-kalkulator">Eie eller leie?</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/111154/hvor-mye-kan-jeg-laane">Hva kan du låne?</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/815994/boliglaanskalkulator">Billigste boliglån</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/820064/lonner-det-seg-aa-gjore-det-selv">
							Lønner det seg å gjøre det selv?
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/355324/artikkel">Varmtvannsforbruk</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/827034/varmepumpekalkulator/">Varmepumpekalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870107/finn-billigste-innboforsikring">
							Finn billigste innboforsikring
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870105/finn-billigste-husforsikring">
							Finn billigste husforsikring
						</A>
					</Li>
				</Ul>
			</Col>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Data og mobil</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/tag/app">Apper</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tag/slik%20gj%C3%B8r%20du%20det/">Slik gjør du det</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tag/anbefalt%20produkt/">Anbefalte produkter</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tester/mobil">Alle mobiltester</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tester/tv">Alle TV-tester</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tester/b%C3%A6rbar-pc">Alle PC-tester</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tag/android">Alt om Android</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tag/iphone">Alt om iPhone</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/tag/facebook">Alt om Facebook</A>
					</Li>
				</Ul>
			</Col>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Motor</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/903961/finn-billigste-vinterdekk">Hva er bilen verdt?</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/104524/importkalkulator">Importkalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/219513/promillekalkulator">Promillekalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/1110/sjekk-heftelser-gratis">Sjekk heftelser</A>
					</Li>
					<Li>
						<A href="http://www.vegvesen.no/Kjoretoy/Eie+og+vedlikeholde/EU-kontroll/Kontrollfrist">
							Sjekk neste EU-kontroll
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870091/finn-billigste-bilforsikring">
							Finn billigste bilforsikring
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/383657/sjekk-hvem-som-eier-bilen">Hvem eier bilen?</A>
					</Li>
				</Ul>
			</Col>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Reise</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/104522/valutakalkulator">Valutakalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/24034/omregneren">Omregneren</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/362192/finn-landnummeret">Landnummer - telefon</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870108/finn-billigste-reiseforsikring">
							Finn billigste reiseforsikring
						</A>
					</Li>
				</Ul>
			</Col>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Økonomi</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/789330/slik-blir-din-skatt-i-2016">Skattekalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/932242/netthandelskalkulator">Netthandelskalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/787895/slosekalkulator">Sløsekalkulator</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/104471/banksparing-sparekalkulator">
							Sparing - best rente
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/5347/betalingsplan-for-laan">Betalingsplanlegger</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/2155/effektiv-rente">Finn effektiv rente</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/115169/kredittkjopskalkulatoren">Pris på kredittkjøp</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/936340/billigste-mobilabonnementer-vaaren-2016">
							Finn billigste mobilabonnement
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/305848/artikkel">Terminbeløp ved renteendring</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870107/finn-billigste-innboforsikring">
							Finn billigste innboforsikring
						</A>
					</Li>
				</Ul>
			</Col>
			<Col sm={4} lg={3}>
				<Ul>
					<SmallHeading>Mer økonomi</SmallHeading>
					<Li>
						<A href="http://www.dinside.no/870105/finn-billigste-husforsikring">
							Finn billigste husforsikring
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870091/finn-billigste-bilforsikring">
							Finn billigste bilforsikring
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/870108/finn-billigste-reiseforsikring">
							Finn billigste reiseforsikring
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/900777/finn-billigste-forsikringspakke">
							Finn billigste forsikringspakke
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/276127/nysgjerrigperkalkulatoren">Egentlig inntekt</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/796283/hvor-lenge-varer-sparepengene">
							Så lenge varer sparepengene
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/382937/den-store-hva-er-du-verdt-kalkulatoren">
							Hvor mye er du verdt?
						</A>
					</Li>
					<Li>
						<A href="http://www.dinside.no/815994/boliglaanskalkulator">
							Boliglånskalkulator - billigst boliglån
						</A>
					</Li>
				</Ul>
			</Col>
		</Aside>
	</CalmGrid>
)

export default withTheme(DinSideToolbox)
