import React from 'react'

/**
 * This needs to be done before loading GTM.
 *
 * Normal "best practice is to do:
 * window.dataLayer = window.dataLayer || []
 * window.dataLayer.push(...)
 *
 * But since we have full controll over what we do
 * we can  simplify. But we must be sure that we load this before GTM
 */

export default class DataLayer extends React.Component {
	initString =
		"window.dataLayer = window.dataLayer || [];window.dataLayer.push({ 'gtm.start': new Date().getTime(), event: 'gtm.js' });" // eslint-disable-line max-len

	componentDidMount() {
		// Some things (like date.getTime() should not be cached, so we add something to the dataLayer on
		// need to have the safequard here becuase we are not setting dataLayer on window if we do not get any props.
		window.dataLayer = window.dataLayer || []
		window.dataLayer.push({ 'gtm.start': new Date().getTime(), 'event': 'gtm.js' })

		if (window.matchMedia('(display-mode: standalone)').matches) {
			window.dataLayer.push({ name: 'platform', content: 'web/pwa' })
		}
	}

	/* eslint-disable react/no-danger */
	render() {
		if (!this.props) return null

		return (
			<script dangerouslySetInnerHTML={{ __html: this.initString + createDataLayer(this.props) }} />
		)
	}
	/* eslint-enable react/no-danger */
}

function createDataLayer(props) {
	if (!props.data) return ''
	return `window.dataLayer = window.dataLayer.concat(${JSON.stringify(props.data)})`
}
