import styled from 'styled-components'

const CtaPopupWrapper = styled.div`
	position: fixed;
	bottom: 10px;
	right: 10px;
	z-index: 1000;
	overflow: hidden;
	opacity: 0;
	display: none;
	transition: opacity 0.25s ease-in-out;

	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
		bottom: 50px;
		right: 50px;
	}

	&.is-visible {
		display: block;
		opacity: 1;
	}

	&.is-open {
		right: 0;
		bottom: 0;
		box-shadow: 0 6px 30px 0 rgba(0, 0, 0, 0.35);

		@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
			box-shadow: -1px -1px 7px 0 rgba(0, 0, 0, 0.07);
			width: 400px;
		}

		.cta-popup-image {
			@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
				display: none;
			}
		}
	}

	.btn-close {
		border: 0;
		background: none;
		padding: 0;
		margin: 0;
		display: block;
	}

	.cta-popup-close-icon {
		color: #444;
		font-size: 15px;
		position: absolute;
		right: 0;
		top: 5px;
		cursor: pointer;
		padding: 5px;
		opacity: 1;
		z-index: 1200;
	}

	.cta-popup {
		width: 100%;
		display: flex;
		align-items: center;
		flex-direction: row;
		overflow: hidden;
	}

	.cta-popup-offer-wrapper {
		display: flex;
		flex-direction: column;
		background: white;
		z-index: 1000;

		&.is-closed {
			width: 0;
		}
	}

	.round-wrapper {
		overflow: hidden;

		&.round {
			border-radius: 0 47% 47% 0;
			margin-right: -5px;

			img {
				border-radius: 50%;
				border: 5px solid #ffffff;
				height: 80px;
				width: 80px;
				object-fit: cover;
			}
		}
	}

	.cta-popup-text-wrapper {
		display: inline-block;
		vertical-align: middle;
		will-change: right;
		padding: 15px;
		position: relative;
		transition: height 0.4s ease-in-out, opacity 0.4s ease-in-out;
		opacity: 1;
		overflow: hidden;
		margin: 40px 0 40px 10px; /* this margin fixes overflow-hidden fucking up box-shadow on white text-wrapper */
		cursor: pointer;
		line-height: 15px;
		@media screen and (min-width: 23em) {
			line-height: normal;
		}

		button {
			padding: 0;
		}

		/* white bg with box-shadow and round-corners */
		&.white {
			background: #fff;
			border-radius: 10px 0 0 10px;
			box-shadow: 0 0 20px 0 rgba(172, 172, 172, 0.55);
			margin-right: -14px;

			button,
			button:visited {
				color: black;
			}
			@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
				box-shadow: 0 0 15px 0 rgba(172, 172, 172, 0.55);
			}
		}

		/* red color and white text */
		&.red {
			background: #e60505;
			box-shadow: unset;
			border-radius: 0;
			margin-right: -3px;

			button,
			button:visited {
				color: white;
			}
		}

		&.show-offer {
			width: 100vw;
			margin: 0;
			padding: 0;
			border-radius: 0;

			img {
				width: 100%;
				display: block;
			}

			@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
				width: 400px;
			}
		}

		&.is-closed {
			display: none;
			width: 0;
			opacity: 0;
			height: 0;
		}
	}

	.cta-popup-text {
		text-decoration: none;
		font-weight: 500;
		text-transform: uppercase;
		font-size: 13px;
		letter-spacing: 0.8px;
		background: none;
		border: 0;
		color: white;
		cursor: pointer;

		@media screen and (min-width: 23em) {
			font-size: 16px;
			letter-spacing: 1px;
		}

		&.show-offer {
			text-align: center;
			letter-spacing: 1px;
			padding: 10px;

			&.top {
				background-color: white;
				color: black;
			}

			&.bottom {
				background-color: red;
				color: white;
				text-transform: none;
			}
		}

		.cta-button {
			border: 1px solid white;
			background-color: white;
			color: #333;
			border-radius: 15px;
			font-size: 12px;
			padding: 5px 15px;
			margin-left: 10px;
			position: relative;
			bottom: 2px;
			cursor: pointer;
		}
	}

	.cta-popup-image-wrapper {
		display: inline-block;
		vertical-align: middle;
		opacity: 1;
		z-index: 30;
		line-height: 24px;
		a {
			display: block;
		}

		.cta-popup-image {
			position: relative;
			width: 60px;
			height: auto;
			cursor: pointer;

			@media screen and (min-width: 23em) {
				width: 65px;
			}
		}
	}

	.fade-in {
		animation: fade-in 1.2s cubic-bezier(0.39, 0.575, 0.565, 1) both;
	}

	.slide-in-right {
		animation: slide-in-right 1.5s ease-in-out both;
	}

	&.popup-covers-footer {
		opacity: 0;
		transition: opacity 0.25s ease-in-out;
	}

	@keyframes fade-in {
		0% {
			opacity: 0;
		}
		100% {
			opacity: 1;
		}
	}

	@keyframes slide-in-right {
		0% {
			transform: translateX(1000px);
			opacity: 0;
		}
		100% {
			transform: translateX(0);
			opacity: 1;
		}
	}
`
export default CtaPopupWrapper
