import styled from 'styled-components'

import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const CouponLink = styled(BlockLink)`
	flex: 1 0 auto;
	border-top-width: 0.3rem;
	border-right-width: 0.3rem;
	border-style: dotted;
	border-color: ${getColor('white')};
	border-bottom: none;
	margin: 0;
	padding: calc(1 / 2 * ${getVariable('verticalBase')}) ${getVariable('horizontalBase')};

	font-size: ${getVariable('uiRegularSize')};
	line-height: ${getVariable('uiRegularLineHeight')};
	font-weight: ${getVariable('uiWeight')};
	font-variant: small-caps;
	text-align: center;

	background-color: ${getColor('grayTint', 'light')};
	color: ${getColor('type')};
	text-decoration: none;

	&:last-child {
		border-right: none;
	}
`

export default CouponLink
