import React from 'react'
import propTypes from 'prop-types'
import { Col as ShinyCol } from '@aller/shiny/src/atoms/Col'
import styled, { css } from 'styled-components'

const StyledCol = styled(ShinyCol)`
	@media screen and (min-width: 600px) {
		display: ${prop => (prop.topnormal ? 'flex !important' : 'initial')};
	}

	${prop =>
		prop.flex &&
		css`
			display: flex !important;
			flex-direction: ${prop.flexDirection};
		`}
`

const Col = ({ children, ...props }) => <StyledCol {...props}>{children}</StyledCol>
Col.propTypes = {
	children: propTypes.node.isRequired,
}

export default Col
