import React from 'react'
import PropTypes from 'prop-types'

import { DotLoader as Loading } from '@aller/shiny/src/atoms/loaders/DotLoader'
import withData from '../../decorators/with-data'

import getData from '../UserInterests/services/get-data'

import ArticlesReadSection from './ArticlesReadSection'
import Main from './Main'

const ArticlesReadStatistic = ({ isLoadingData, error, ...rest }) => {
	if (error) {
		return <div>Oops, something went wrong.</div>
	}

	if (isLoadingData) {
		return (
			<ArticlesReadSection center>
				<Loading />
			</ArticlesReadSection>
		)
	}

	return <Main {...rest} />
}

ArticlesReadStatistic.propTypes = {
	error: PropTypes.bool.isRequired,
	isLoadingData: PropTypes.bool.isRequired,
}

const DailyStatistic = withData({
	fetchData: getData,
	dataProp: 'userData',
	loadingProp: 'isLoadingData',
})(ArticlesReadStatistic)

const WeeklyStatistic = withData({
	fetchData: getData,
	dataProp: 'userData',
	loadingProp: 'isLoadingData',
})(ArticlesReadStatistic)

const Switcher = props => {
	const { _dataOptions } = props
	return _dataOptions.statisticType === 'daily' ? (
		<DailyStatistic {...props} />
	) : (
		<WeeklyStatistic {...props} />
	)
}
Switcher.propTypes = {
	_dataOptions: PropTypes.shape({ statisticType: PropTypes.string }).isRequired,
}

export default Switcher
