import styled from 'styled-components'

import { DymoHeading } from '@aller/shiny/src/atoms/DymoHeading'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const OverImageHeading = styled(DymoHeading)`
	position: relative;
	top: 0;

	/* Move the bottom padding to any
	following element, if it exists */
	margin-bottom: 0;
	& + * {
		margin-top: ${getVariable('verticalBase')};
	}

	&&& {
		@media screen and (min-width: ${getVariable('largeWidth')}) {
			top: -${({ skin: { needsPadding } }) => needsPadding && getVariable('headingHugeLineHeight')};
			margin-bottom: -${({ skin: { needsPadding } }) => needsPadding && getVariable('headingHugeLineHeight')};
		}
	}
`

export default OverImageHeading
