import React from 'react'
import PropTypes from 'prop-types'

const OldGenericAd = ({ id, adUnit, lazyload, sizes, targeting, size, collapse }) => {
	if (id === 'ad-skyscraper-right0') {
		return null
	}

	const paddingLeft = id === 'ad-topbanner0' ? 22 : 7
	const { width, height } = size
	// remove px from string
	const widthNr = width.length > 2 ? width.slice(0, -2) : width
	const heightNr = height.length > 2 ? height.slice(0, -2) : height

	const isNetboard = id.indexOf('netboard') > 0
	const netBoardStyles = isNetboard
		? {
				marginLeft: 'auto',
				marginRight: 'auto',
		  } // eslint-disable-line no-mixed-spaces-and-tabs
		: {}

	const styles = {
		...netBoardStyles,
		width: `${size.width}`,
		paddingLeft,
	}
	return (
		<div className="containMe adunit-wrapper" style={styles}>
			<div
				id={id}
				className={`adunit medium-${widthNr}x${heightNr}-scaled large-${widthNr}x${heightNr}`}
				data-top-offset="0"
				data-offsetheight="0"
				itemScope=""
				itemType="http://schema.org/WPAdBlock"
				data-sizes={`[[[0,0],${sizes}]]`}
				json={targeting}
				data-slot={adUnit}
				data-load-on={lazyload ? 'view' : 'load'}
				data-collapse={collapse}
			/>
		</div>
	)
}

// to see real proptypes see what you get back from the api. See Ad type.
/* eslint-disable react/forbid-prop-types */
OldGenericAd.propTypes = {
	id: PropTypes.string.isRequired,
	sizes: PropTypes.any.isRequired,
	size: PropTypes.any.isRequired,
	lazyload: PropTypes.bool.isRequired,
	adUnit: PropTypes.string.isRequired,
	targeting: PropTypes.string.isRequired,
	collapse: PropTypes.bool.isRequired,
}

OldGenericAd.shouldComponentUpdate = () => {
	return false
}
// TopBanner.onSlotRenderEnded = (slot) => {

// }

export default OldGenericAd
