import React from 'react'
import PropTypes from 'prop-types'
import { GenericAd } from '@aller/shiny/src/molecules/GenericAd'

import AdSlot from './AdSlot'

const Smartbanner = ({ id }) => {
	return (
		<AdSlot
			adSlotProps={{
				id,
			}}
			rootMargin="400px"
			wrapperProps={{
				width: '980px',
				height: '300px',
				shouldHideAttribution: false,
			}}
			wrapper={GenericAd}
		/>
	)
}

Smartbanner.propTypes = {
	id: PropTypes.string.isRequired,
}

export default Smartbanner
