import React from 'react'
import { withTheme } from 'styled-components'
import PropTypes from 'prop-types'
import { LogiclessModal } from '@aller/shiny/src/atoms/LogiclessModal'
import { LargeHeading } from '@aller/shiny/src/atoms/Heading'
import { Button } from '@aller/shiny/src/atoms/Button'
import { AdsContext } from '../../store/ads'

const Title = ({ theme: { name } }) => (
	<>
		{name} er en del av <b>Aller Media</b>
	</>
)

Title.propTypes = {
	theme: PropTypes.shape({
		name: PropTypes.string,
	}).isRequired,
}

const ThemedTitle = withTheme(Title)

const Modal = () => (
	<AdsContext.Consumer>
		{({ showModal, closeModal }) => (
			<LogiclessModal isOpen={showModal} title={<ThemedTitle />} closeModal={closeModal}>
				<LargeHeading>Hvorfor ser du denne annonsen</LargeHeading>
				<p>
					Nettstedet du nå besøker blir i stor del finansiert av annonseinntekter. Basert på din
					tidligere aktivitet hos oss, vil du få annonser vi tror kan interessere deg.
				</p>
				<p>Du velger selv om du ønsker å endre dine innstillinger</p>
				<Button outline background="buttonColor">
					<a
						href="https://personvern.aller.no/annonseinnstillinger.html"
						rel="noopener noreferrer"
						target="_blank"
					>
						Les mer om innstillinger
					</a>
				</Button>
				<LargeHeading>Om Aller Media og annonsering</LargeHeading>
				<p>
					Aller Media eier nettstedene Dagbladet, Sol, DinSide, KK, Se og Hør, Lommelegen, Topp og
					Vi
				</p>
				<Button outline background="buttonColor">
					<a
						href="https://personvern.aller.no/relevantinnhold.html"
						rel="noopener noreferrer"
						target="_blank"
					>
						Les mer om Aller Media og annonser
					</a>
				</Button>
			</LogiclessModal>
		)}
	</AdsContext.Consumer>
)

export default Modal
