/* eslint-disable react/state-in-constructor */
import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { FullscreenAd } from '@aller/shiny/src/molecules/FullscreenAd'
import { GenericAd } from '@aller/shiny/src/molecules/GenericAd'

import AdSlot from './AdSlot'

class Fullscreen extends Component {
	state = {
		shouldHide: false,
		isIE11: false,
		Wrapper: FullscreenAd,
		rootMarginValue: '713px',
		width: '100%',
		height: '100vh',
	}

	componentDidMount() {
		// Check if browser is IE, because we remove parallax on fullscreen on IE
		if (
			navigator.userAgent.indexOf('MSIE') !== -1 ||
			navigator.appVersion.indexOf('Trident/') > 0
		) {
			this.setState({
				isIE11: true,
			})
		}
	}

	adListener(event) {
		// If delivered ad is not a fullscren, then transform this ad slot to a genericAd slot
		if (!event.isEmpty && event.size[0] > 1) {
			this.setState({
				Wrapper: GenericAd,
				rootMarginValue: '400px',
				width: `${event.size[0]}px`,
				height: `${event.size[1]}px`,
			})
		}
		this.setState({
			shouldHide: event.isEmpty,
		})
	}

	render() {
		const { id } = this.props
		const { shouldHide, isIE11, Wrapper, rootMarginValue, width, height } = this.state

		return (
			<AdSlot
				rootMargin={rootMarginValue}
				adSlotProps={{
					id,
				}}
				wrapperProps={{
					width,
					height,
					shouldHide,
					isIE11,
				}}
				adListener={event => this.adListener(event)}
				wrapper={Wrapper}
			/>
		)
	}
}

Fullscreen.propTypes = {
	id: PropTypes.string.isRequired,
}

export default Fullscreen
