const path = require('path')

module.exports = ({ config, mode }) => {
  config.module.rules.push({
			test: /\.(ts|tsx|js|jsx)$/,
			loader: require.resolve('babel-loader'),
			exclude: /node_modules\/(?!(@aller\/shiny)\/).*/,
			options: {
				presets: [['react-app', { flow: false, typescript: true }]],
			},
  });
	config.module.rules.push({
			test: /\.graphql|\.gql$/,
			loaders: ['graphql-tag/loader'],
			include: path.resolve(__dirname, '../')
	})
  config.resolve.extensions.push('.ts', '.tsx');
  return config;
};
