import 'storybook-chromatic'
import { configure, addDecorator } from '@storybook/react'
import { withContexts } from '@storybook/addon-contexts/react'
import { withA11y } from '@storybook/addon-a11y'
import { contexts } from './configs/contexts'

addDecorator(withContexts(contexts))
addDecorator(withA11y)

const req = require.context('../../', true, /.stories.(js|ts)x?$/)
function loadStories() {
	require('../stories/index.js')
	require('../../shiny/stories/index.js')
	req.keys().forEach(filename => req(filename))
}

configure(loadStories, module)
