/* eslint-disable import/prefer-default-export */
const logger = require('../log')

/**
 * Class representing a logger with specific settings related to
 * video functionality
 */
class VideoLogger {
	constructor(trackerName) {
		const logPrefix = `VIDEO:${trackerName}`

		if (VideoLogger.precondition) {
			localStorage.debug = '*VIDEO*'
			this.loggerInstance = logger(logPrefix)
		} else {
			localStorage.removeItem('debug')
		}
	}

	/**
	 * Condition to turn logger on
	 */
	static get precondition() {
		const requiredQuery = 'V_DEBUG'

		return window.location.search && window.location.search.endsWith(requiredQuery)
	}

	log(message) {
		if (this.loggerInstance) {
			this.loggerInstance.verbose(message)
		}
	}

	error(message) {
		if (this.loggerInstance) {
			this.loggerInstance.error(message)
		}
	}
}

export { VideoLogger }
