/* eslint-disable class-methods-use-this, no-restricted-syntax, import/prefer-default-export */

/**
 * @class Class main responsibility of which
 * is notifying trackers by events got from
 * event source
 */
class Dispatcher {
	constructor(eventSource, trackerFactories, options) {
		this.eventSource = eventSource
		this.trackers = []
		this.rawTrackers = [] // trackers, for which we don't need to map events

		this.options = options

		trackerFactories.forEach(f => this.register(f))
	}

	/**
	 * @function
	 * @private
	 * Create and save tracker
	 * @param {*} trackerFactory - class creating a tracker
	 */
	register(trackerFactory) {
		trackerFactory
			.create(this.options)
			.then(tracker => {
				tracker.receivesRawEvents ? this.rawTrackers.push(tracker) : this.trackers.push(tracker)
			})
			.catch(err => {
				// eslint-disable-next-line no-console
				console.error('error', trackerFactory, err)
			})
	}

	/**
	 * @function
	 * Notify all saved trackers with event, got from player
	 * @param {*} playerEvent - event got from player
	 */
	dispatch(rawPlayerEvent) {
		this.eventSource.pipe(
			rawPlayerEvent,
			e => this.notify(this.trackers, e),
		)

		this.eventSource.pipeRaw(rawPlayerEvent, e => this.notify(this.rawTrackers, e))
	}

	notify(trackers, e) {
		if (e) {
			trackers.forEach(tracker => tracker.log(e))
		}
	}
}

export { Dispatcher }
