/* eslint-disable import/prefer-default-export */
import { VideoLogger } from '../../videoLogger' // TODO: needs to be implemented
import { LinkPulseTracker } from './tracker'
import { LPCLient } from './client'
import { VideoEvent } from '../../videoEvent'
import { DestEventTypes } from '../../eventTypes'

/* eslint-disable class-methods-use-this, no-unused-expressions */

const factoryState = {
	IDLE: 0,
	EVENT_ATTACHED: 1,
	LOADED: 2,
}

class LinkPulseTrackerFactory {
	constructor(player) {
		this.player = player

		this.state = factoryState.IDLE
	}

	create(options) {
		return new Promise(resolve => {
			// remark regarding window.top
			// agenda uses video embed in iframe
			if (window.top.LP4 && this.state === factoryState.IDLE) {
				this.state = factoryState.LOADED
			}

			if (this.state === factoryState.IDLE) {
				this.waitForLoad(() => resolve(this.createLPLogger(options)))
			} else if (this.state === factoryState.LOADED) {
				resolve(this.createLPLogger(options))
			}
		})
	}

	waitForLoad(cb) {
		window.top.addEventListener('lpVideoLogEvent', e => {
			if (e.detail.logtype === 'initdone') {
				this.state = factoryState.LOADED

				cb()
			}
		})
		this.state === factoryState.EVENT_ATTACHED
	}

	createLPLogger(options) {
		const clientLogger = new VideoLogger('LinkPulse_client')
		const trackerLogger = new VideoLogger('LinkPulse_tracker')

		const lpClient = new LPCLient(clientLogger)
		const lpLogger = new LinkPulseTracker(lpClient, trackerLogger)

		if (this.player.getViewable()) {
			this.raiseViewEvent(lpLogger, options)
		}

		return lpLogger
	}

	/**
	 * @function if LP4 lib is loaded
	 * later than INSCREEN event is sent, than we should
	 * do it manually
	 */
	raiseViewEvent(lpLogger, { videoType, videoUrl }) {
		const config = this.player.getConfig()
		const viewEvent = new VideoEvent(DestEventTypes.INSCREEN, {
			videoType,
			...config,
		})
		lpLogger.log(viewEvent)
	}
}

export { LinkPulseTrackerFactory }
