/* eslint-disable import/prefer-default-export */
import throttle from 'lodash.throttle'

const SEEK_THROTTLE_MS = 1500

/**
 * @class Class representing
 * calling LP lib,
 * created primarily for logging and docs
 */
class LPCLient {
	constructor(logger) {
		this.logger = logger
		this.logSeek = throttle(offset => this.logPlaystart(offset), SEEK_THROTTLE_MS)
	}

	createLogger() {
		// eslint-disable-next-line new-cap
		const lp = new window.top.LP4.video.logger()

		this.lp = lp
	}

	loggerInitialized() {
		return this.lp
	}

	getLoggedPlaystart() {
		return this.lp.getLoggedPlaystart()
	}

	getLoggedLoadstart() {
		return this.lp.getLoggedLoadstart()
	}

	setVideoUrl(url) {
		this.logger.log(`calling setVideoUrl, url ${url}`)
		return this.lp.setVideoUrl(url)
	}

	setPageUrl(url) {
		this.logger.log(`calling setPageUrl, url ${url}`)
		return this.lp.setPageUrl(url)
	}

	setVideoImg(img) {
		this.logger.log(`calling setVideoImg, img: ${img}`)
		return this.lp.setVideoImg(img)
	}

	setVideoTags(tags) {
		this.logger.log(`calling setVideoTags, tags: ${tags}`)
		if (!tags) {
			tags = false // explicitly setting "no tags set"
			// otherwise will take tags from outer article
		}
		return this.lp.setVideoTags(tags)
	}

	setVideoTitle(title) {
		this.logger.log(`calling setVideoTitle, title: ${title}`)
		return this.lp.setVideoTitle(title)
	}

	setPageType(type) {
		this.logger.log(`calling setPageType, type: ${type}`)
		return this.lp.setPageType(type)
	}

	setVideoCategory(category) {
		this.logger.log(`calling setVideoCategory, category: ${category}`)
		return this.lp.setVideoCategory(category)
	}

	logLoadstart() {
		this.logger.log('calling logLoadstart')
		return this.lp.logLoadstart()
	}

	setPaused(state) {
		this.logger.log(`calling setPaused, isPaused: ${state}`)
		return this.lp.setPaused(state)
	}

	setDuration(duration) {
		if (duration === Infinity) {
			duration = 0
		}
		this.logger.log(`calling setDuration, duration: ${duration}`)
		return this.lp.setDuration(duration)
	}

	logPlaystart(position, rewind) {
		this.logger.log(`calling logPlaystart, position: ${position}, rewind: ${rewind}`)
		return this.lp.logPlaystart(position, rewind)
	}

	logEnded(position) {
		this.logger.log(`calling logEnded, position: ${position}`)
		return this.lp.logEnded(position)
	}

	logTimeupdate(time) {
		this.logger.log(`calling logTimeupdate, time: ${time}`)
		return this.lp.logTimeupdate(time)
	}
}

export { LPCLient }
