/* eslint-disable import/prefer-default-export */
import { VideoLogger } from '../../videoLogger'
import { TNSTracker } from './tracker'

/* eslint-disable class-methods-use-this */
class TNSTrackerFactory {
	constructor(player) {
		this.player = player
	}

	create() {
		return new Promise(resolve => {
			const springSensors = new window.SpringStreams('dbstream')
			springSensors.debug = v => {}

			window.addEventListener(
				'beforeunload',
				() => {
					springSensors.unload()
					// give time for submission
					const start = new Date()
					let now = null
					do now = new Date()
					while (now - start < 100)
				},
				false,
			)

			const logger = new VideoLogger('TNS')
			const tracker = new TNSTracker(springSensors, logger)
			resolve(tracker)
		})
	}
}

export { TNSTrackerFactory }
