/* eslint-disable import/prefer-default-export */
import { LinkPulseTrackerFactory } from '../../trackers'
import { JWEventTypes } from '../../eventTypes'

/**
 * Extend this class to add configuration
 * @param {*} player - JW Player instance
 */
const jwTrackingConfig = player => {
	/**
	 * @property {object[]} factories - factories for trackers that will
	 * be notified when player emits an event
	 * @property {string[]} eventsToListen - event types that will be listened
	 * from a player
	 */
	return {
		factories: [new LinkPulseTrackerFactory(player)],
		eventsToListen: [
			JWEventTypes.PAUSE,
			JWEventTypes.SEEK,
			JWEventTypes.VIEWABLE,
			JWEventTypes.TIME,
			JWEventTypes.CONTROLS,
			JWEventTypes.PLAY,
			JWEventTypes.PLAYLIST_ITEM,
			JWEventTypes.COMPLETE,
			JWEventTypes.AD_IMPRESSION,
		],
	}
}

export { jwTrackingConfig }
