export async function getPaywallInfo(id) {
	const url = `${process.env.JW_API_PROXY_ENDPOINT}/api/videos/${id}/auth`

	try {
		const res = await fetch(url)

		return await res.json()
	} catch (e) {
		// eslint-disable-next-line no-console
		console.log('error while doing fetch to jw-api-proxy', e)
		throw e
	}
}

export function initializePaywallOverlay(id, loggedIn, error) {
	// if user doesn't have rights to watch it
	const video = document.querySelector(`[data-videoid="${id}"]`)
	video.style.display = 'none'
	const paywall = document.querySelector(`.video-paywall-${id}`) // get only one related to player
	paywall.style.display = 'block'

	if (error) {
		paywall.querySelector('.error').style.display = 'flex'
	} else {
		paywall.querySelector('.overlay').style.display = 'flex'

		if (loggedIn) {
			paywall.querySelector('.paywall-footer').style.display = 'none'
		}
	}
}

const getCookie = name => {
	const match = document.cookie.match(new RegExp(`(^| )${name}=([^;]+)`))
	if (match) return match[2]
	return null
}

export async function withAuthResolved(mediaid, plussproductid) {
	return new Promise((resolve, reject) => {
		if (!plussproductid) return resolve({ accessed: true })

		const dugState = getCookie('dug-state')
		const loggedIn = !!dugState

		return getPaywallInfo(mediaid)
			.then(({ accessed }) => {
				if (accessed) {
					return resolve({ accessed: true })
				}
				return resolve({ accessed: false, loggedIn })
			})
			.catch(e => {
				// eslint-disable-next-line no-console
				console.error('Error while getting paywall info', e)
				return reject()
			})
	})
}
