/* global describe, expect, test */
import { parseCustom, parseStartTime, DEFAULT_AUTOPLAYTIMER } from './parse-custom'

describe('testing of parsing custom parameters', () => {
	test('should parse valid JSON-stringified object', () => {
		const arg = JSON.stringify({
			startfrom: 10,
			repeat: true,
		})

		const expected = {
			starttime: 10,
			repeat: true,
			autoplaytimer: DEFAULT_AUTOPLAYTIMER,
		}

		expect(parseCustom(arg)).toMatchObject(expected)
	})

	test('should return empty object in case of not passing custom params', () => {
		expect(parseCustom(undefined)).toMatchObject({})
	})

	test('should return empty object if JSON is malformed', () => {
		expect(parseCustom('malformed[]JSON')).toMatchObject({})
	})

	test('should return 0 for negative starttime', () => {
		expect(parseStartTime(-5)).toBe(0)
	})
})
