/**
 * Enum for JW Event names
 * @enum {string}
 */
const JWEventTypes = {
	PAUSE: 'pause',
	PLAY: 'play',
	BEFORE_PLAY: 'beforePlay',
	PLAYLIST_ITEM: 'playlistItem',
	COMPLETE: 'complete',
	TIME: 'time',
	CONTROLS: 'controls',
	SEEK: 'seek',
	VIEWABLE: 'viewable',
	AD_IMPRESSION: 'adImpression',
}

/**
 * Enum for events that are ready for consumtion
 * by trackers
 * @enum {string}
 */
const DestEventTypes = {
	PAUSE: 'pause',
	PLAY: 'play',
	CONTINUE: 'continue',
	AUTOPLAY: 'autoplay',
	REPLAY: 'replay',
	STOP: 'stop',
	CONTROLS: 'controls',
	SEEK: 'seek',
	TIME: 'time',
	INSCREEN: 'inscreen',
	NEW_PLAYLIST_ITEM: 'newPlaylistItem', // fired when new video is in player
}

export { JWEventTypes, DestEventTypes }
