/* eslint-disable import/prefer-default-export */
const dbAutoplay = {
	path: '/8578/Aller_webtv/autoplay/dagbladet',
	appnexus: {
		skip: {
			invCode: 'dagbladet_video_autoplay_skip',
		},
		nonskip: {
			invCode: 'dagbladet_video_autoplay_nonskip',
		},
	},
}

const dbClick2Play = {
	path: '/8578/Aller_webtv/click_to_play/dagbladet',
	appnexus: {
		skip: {
			invCode: 'dagbladet_video_click2play_skip',
		},
		nonskip: {
			invCode: 'dagbladet_video_click2play_nonskip',
		},
	},
}

export class DbAdConfig {
	constructor(autoplay) {
		this.autoplay = autoplay
	}

	getConfig() {
		const config = this.autoplay ? dbAutoplay : dbClick2Play

		return {
			publisher: 'www.dagbladet.no',
			adform: {
				mid: '651060',
			},
			...config,
		}
	}
}
