/**
 * @function adjustBehaviour
 * adjust playerBehaviour depending
 * on business needs
 * @param player - jw player instance
 */
export function adjustBehaviour(player) {
	click2PlayIfMuted(player)
}

/**
 * @function click2PlayIfMuted
 * if player has no ads, then
 * and browser restrict autoplay
 * then JW will mute player in order
 * to force autoplay.
 * We don't wanna that
 * @param player - jw player instance
 */
function click2PlayIfMuted(player) {
	const playerConfig = window.jwDefaults
	const { autostart, advertising } = playerConfig

	player.on('firstFrame', () => {
		if (autostart && !advertising && isMutedByBrowserItself(player, playerConfig)) {
			player.stop()
			player.setMute(false)
		}
	})
}

function isMutedByBrowserItself(player, playerConfig) {
	const { mute } = playerConfig

	return player.getMute() && !mute
}
