import { ImageSource } from '../../types/images'
import { Column } from '../../components/FlexCol/types'
import { Labrador_Image, Labrador_Metadata } from '../../graphql/types'

export interface StandardizedArticlePreviewFormat {
	articleSource: string
	imageUrl?: string
	originalImageUrl?: string
	imageSources?: ImageSource[]
	imageRatio?: number
	dataLabel?: string
	labelColor?: string
	title: string
	subtitle?: string
	url?: string
	host?: string
	tag?: string
	column?: Column
	backgroundColor?: string
	secondaryTitle?: string
	blinkPreset?: string
	paywall?: boolean
	labrador?: LabradorProps
	xavier?: XavierProps
}

interface LabradorProps {
	id: number
	contentMarketingPublisher: string
	image: Labrador_Image
	metadata: Labrador_Metadata | null
	textOverlayBackground?: string | null
	width: number
	parentWidth: any
	identifier: string
}

interface XavierProps {
	plugHeight: string
	plugWidth: string
	fromFront: boolean
	cerebroScore: number
}
