import { getLabelColor } from '@aller/shared/components/SolPlug/Logan/LabradorArticlePreview'

import { StandardizedArticlePreviewFormat } from './types'

export function standardizeArticleFromXavier(article: any): StandardizedArticlePreviewFormat {
	const {
		cleanImage,
		ratio,
		backgroundColor,
		dataLabel,
		title,
		subtitle,
		secondaryTitle,
		url,
		sectionTag,
		preset,
		plugHeight,
		plugWidth,
		fromFront,
		cerebroScore,
		column,
	} = article

	let imageUrl: string | undefined
	let imageRatio: number | undefined
	if (cleanImage) {
		imageUrl = cleanImage as string
		imageRatio = ratio
	}

	return {
		articleSource: 'Xavier',
		imageUrl,
		imageRatio,
		column,
		backgroundColor,
		dataLabel,
		labelColor: dataLabel ? getLabelColor(dataLabel) : undefined,
		title,
		subtitle,
		secondaryTitle,
		url,
		tag: sectionTag,
		blinkPreset: preset,
		xavier: {
			plugHeight,
			plugWidth,
			fromFront,
			cerebroScore,
		},
	}
}

export default function standardizeArticlesFromXavier(
	articles: any[],
): StandardizedArticlePreviewFormat[] {
	return articles.map((article: any) => standardizeArticleFromXavier(article))
}
