import { StandardizedArticlePreviewFormat } from './types'
import { HarvesterItem } from '../../services/harvester'
import { cloudify } from '../generate-cloudify-image-urls'

export function standardizeArticleFromHarvester(
	article: HarvesterItem,
): StandardizedArticlePreviewFormat {
	const {
		title,
		url,
		host,
		fields: { image },
	} = article

	let imageUrl: string | undefined
	let originalImageUrl: string | undefined
	if (image) {
		originalImageUrl = image
		imageUrl = cloudify(image, { width: 980, quality: 85 })
	}

	return {
		articleSource: 'Harvester',
		imageUrl,
		originalImageUrl,
		title,
		url,
		host,
	}
}

export default function standardizeArticlesFromHarvester(
	articles: HarvesterItem[],
): StandardizedArticlePreviewFormat[] {
	return articles.map((article: HarvesterItem) => standardizeArticleFromHarvester(article))
}
