const debug = require('debug')
const { stringify } = require('circular-json')

function debugApp(packageName) {
	const verbose = debug(`wolverine:verbose:${packageName}`)
	const log = debug(`wolverine:log:${packageName}`)
	const deprecated = debug(`wolverine:deprecated:${packageName}`)
	const warning = debug(`wolverine:warning:${packageName}`)
	const error = debug(`wolverine:error:${packageName}`)

	return {
		verbose: logHandler.bind(this, verbose),
		log: logHandler.bind(this, log),
		deprecated: logHandler.bind(this, deprecated),
		warning: logHandler.bind(this, warning),
		error: logHandler.bind(this, error),
		errorStructured: message => {
			/* eslint-disable no-console */
			console.error(
				stringify({
					'@timestamp': new Date().toISOString(),
					'packageName': `wolverine:error:${packageName}`,
					...message,
				}),
			)
		},
		format,
	}
}

function logHandler(logger, ...messages) {
	if (messages.length === 0) {
		return
	}
	const oneMessage = format(...messages)
	logger(oneMessage)
}

function format(...messages) {
	if (messages.length === 0) {
		return ''
	}
	return messages.reduce((finaleMessage, message = {}) => {
		if (message && typeof message.stack === 'string') {
			const { stack = '', message: errorMsg = '', code = '', ...rest } = message
			const formatCode = code ? `${code}:` : ''
			return JSON.stringify({
				'@timestamp': Date.now(),
				'message': finaleMessage || errorMsg,
				'errorCode': formatCode,
				errorMsg,
				stack,
				...rest,
			})
		}
		return `${finaleMessage}${stringify(message)}`
	}, '')
}

module.exports = debugApp
