interface Size {
	[index: number]: any
}

const sizeMap: Size = {
	1: {
		characters: 20,
		characterHeight: 23,
	},
	2: {
		characters: 22,
		characterHeight: 23,
	},
	3: {
		characters: 25,
		characterHeight: 23,
	},
	4: {
		characters: 31,
		characterHeight: 21.5,
	},
	5: {
		characters: 27,
		characterHeight: 36,
	},
	6: {
		characters: 33,
		characterHeight: 32,
	},
	7: {
		characters: 31,
		characterHeight: 47,
	},
	8: {
		characters: 32,
		characterHeight: 42,
	},
	9: {
		characters: 33,
		characterHeight: 23,
	},
	10: {
		characters: 34,
		characterHeight: 23,
	},
	11: {
		characters: 35,
		characterHeight: 23,
	},
	12: {
		characters: 36,
		characterHeight: 23,
	},
}

const descriptionSingleLineHeight = 20

interface Article {
	title: string
	label?: string
	description?: string
	plugHeight: number
	plugWidth: number
	imageRatio: number
}

export function getImageRatioByTitle(articles: Article[], size: number[]): Article[] {
	let maxPlugHeight = 0

	// Calculate the height of each plug in the row, and figure out which one is the tallest
	articles.map((article, i) => {
		const words = article.title.split(' ')
		let charCounter = 0
		let rowCounter = 1
		let titleRow = ''
		words.forEach((word: any) => {
			charCounter = charCounter + word.length + 1

			if (charCounter > sizeMap[size[i]].characters) {
				// console.log(titleRow)
				titleRow = word
				charCounter = word.length
				rowCounter += 1
			} else if (titleRow !== '') {
				titleRow = `${titleRow} ${word}`
			} else {
				titleRow = word
			}
		})

		// console.log(titleRow)
		// console.log(' ')

		// (total grid width / 12) * plug column size - plug margins
		const plugWidth = (994 / 12) * size[i] - 14

		// Default imageRatio is 0.5 (half the size of the plug width)
		const originalImageHeight = plugWidth / 2

		// Number of rows * the character height set in the config
		const titleHeight = rowCounter * sizeMap[size[i]].characterHeight

		const labelHeight = article.label ? 15 : 0
		const descriptionHeight = article.description
			? Math.ceil(article.description.length / 50) * descriptionSingleLineHeight
			: 0
		const plugHeight = originalImageHeight + titleHeight + labelHeight + descriptionHeight
		if (plugHeight > maxPlugHeight) {
			maxPlugHeight = plugHeight
		}
		article.plugHeight = plugHeight
		article.plugWidth = plugWidth
		return article
	})

	articles.map((article, i) => {
		if (maxPlugHeight > article.plugHeight) {
			// Difference between the height of this plug and the tallest plug
			const pixelDiff = maxPlugHeight - article.plugHeight

			const percentageIncrease = pixelDiff / article.plugWidth

			// Increases the image ratio of the smallest plug to fill all of the whitespace
			article.imageRatio = 0.5 + percentageIncrease
		} else {
			article.imageRatio = 0.5
		}
		return article
	})

	return articles
}
