/* eslint-disable */
function extractHostname(url) {

	let hostname
	// find & remove protocol (http, ftp, etc.) and get hostname

	if (url.indexOf('//') > -1) {
			hostname = url.split('/')[2]
	} else {
			hostname = url.split('/')[0]
	}

	// find & remove port number
	hostname = hostname.split(':')[0]

	// find & remove "?"
	hostname = hostname.split('?')[0]

	//strip out only the top and second level domain
	const temp = hostname.split('.').reverse();
	hostname = temp[1] + '.' + temp[0];
	return hostname
}

// To address those who want the "root domain," use this function:
function extractRootDomain(url) {
	let domain = extractHostname(url)

	const splitArr = domain.split('.')

	const arrLen = splitArr.length

	// extracting the root domain here
	// if there is a subdomain
	if (arrLen > 2) {
		domain = `${splitArr[arrLen - 2]}.${splitArr[arrLen - 1]}`
		// check to see if it's using a Country Code Top Level Domain (ccTLD) (i.e. ".me.uk")
		if (splitArr[arrLen - 2].length == 2 && splitArr[arrLen - 1].length === 2) {
			// this is using a ccTLD
			domain = `${splitArr[arrLen - 3]}.${domain}`
		}
	}
	return domain
}

const getHostname = url => {
	if (!url) {
		return null
	}
	const domain = extractRootDomain(url)
	return domain
}

export default getHostname
