function formatTime(mins) {
	let hours = 0
	let minutes = 0

	if (mins) {
		hours = Math.floor(mins / 60)
		minutes = mins % 60
	}

	return `${hours ? `${hours}t ` : ''} ${minutes ? `${minutes}min ` : ''}`
}

// returns 'desktop' or 'mobile' strings
function getDevice(req) {
	const viewPortHeader = req.header('X-Ua-Viewport')

	const hasXUAViewport = viewPortHeader && viewPortHeader !== ''
	return hasXUAViewport ? viewPortHeader : 'mobile'
}

/**
 * @function getLastUrlSegment
 * @returns last segment of url
 * @example
 * // for url www.seher.no/test/testId returns testId
 */
function getLastUrlSegment() {
	const pathSegments = window.location.pathname.split('/')
	return pathSegments[pathSegments.length - 1]
}

/**
 * @function getEnvValueForBrowser
 * @returns env value
 * depending on app, that is used
 */
function getEnvValueForBrowser(key) {
	// checking for NEXT APP first
	/* eslint-disable-next-line no-underscore-dangle */
	if (typeof window !== 'undefined' && window.__NEXT_DATA__ && window.__NEXT_DATA__.runtimeConfig) {
		/* eslint-disable-next-line no-underscore-dangle */
		return window.__NEXT_DATA__.runtimeConfig[key]
	}
	// then assuming it's webpack app
	// checking via process.env because we need it to work in a
	// chunk, which is built via separate webpack config,
	// which recognizes process.env.JW_API_PROXY_ENDPOINT
	return process.env.JW_API_PROXY_ENDPOINT
}

module.exports = {
	formatTime,
	getDevice,
	getLastUrlSegment,
	getEnvValueForBrowser,
}
