/* eslint-env jest */

import chunkArray from './chunk-array'

test('Check chunking array of 25 items gives 5 chunks of 5', () => {
	const array = []
	for (let i = 0; i < 25; i++)  { // eslint-disable-line
		array.push(i)
	}

	const chunks = chunkArray(array, 5)

	expect(chunks.length).toBe(5)
	chunks.forEach((chunk, i) => {
		expect(chunk.length).toBe(5)
		chunk.forEach((item, j) => {
			const expectedValue = i * 5 + j
			expect(item).toBe(expectedValue)
		})
	})
})

test('Check chunking array of 29 items gives 5 chunks of 5', () => {
	const array = []
	for (let i = 0; i < 29; i++)  { // eslint-disable-line
		array.push(i)
	}

	const chunks = chunkArray(array, 5)

	expect(chunks.length).toBe(5)
	chunks.forEach((chunk, i) => {
		expect(chunk.length).toBe(5)
		chunk.forEach((item, j) => {
			const expectedValue = i * 5 + j
			expect(item).toBe(expectedValue)
		})
	})
})
