import React from 'react'
import { Col, Grid } from '@aller/shiny/src'
import Row from '../../components/Row'
import ArticlePreview from '../../components/ArticlePreview'
import Carousel from '../../components/video/carousel'
import { videos, label, props, carouselProps } from './video-data'

export default () => (
	<>
		<Grid>
			<Row>
				<Col xs={12} md={8}>
					<ArticlePreview {...props} />
				</Col>
				<Col xs={12} md={4}>
					<Row>
						<ArticlePreview {...props} standFirst="" column={{ xs: 6, md: 12 }} />
						<ArticlePreview {...props} standFirst="" column={{ xs: 6, md: 12 }} />
					</Row>
				</Col>
			</Row>
			<Row>
				<Col xs={12}>
					<Carousel
						{...carouselProps}
						label={label}
						headingComponent="frontSmall"
						videos={videos}
					/>
				</Col>
			</Row>
			<Row>
				<Col xs={12}>
					<Carousel
						{...carouselProps}
						label={label}
						headingComponent="frontSmall"
						videos={videos}
					/>
				</Col>
			</Row>
		</Grid>
	</>
)
