import React from 'react'

import { defaultTheme } from '@aller/shiny/src/themes/default-theme'
import { storiesOf } from '@storybook/react'
import { HugeHeading } from '@aller/shiny/src/atoms/Heading'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { ShinyThemeProvider } from '@aller/shiny/src/atoms/ShinyThemeProvider'

const Welcome = () => (
	<ShinyThemeProvider theme={defaultTheme}>
		<Grid>
			<>
				<HugeHeading>Storybook for Wolverine </HugeHeading>
				<p>To have rapid prototyping and good testing at the same time</p>
				<p>Please try to test all components that are not covered by Shiny</p>
				<p>
					If your component could be reusable and are a visual component it should be added to Shiny
					and not here
				</p>
				<p>Please remember to cover all the variants of state your component could be in.</p>
			</>
		</Grid>
	</ShinyThemeProvider>
)

export default () => {
	storiesOf('Welcome', module).add('to wolverine-frontend', () => <Welcome />)
}
