import React from 'react'

import { PlussBarContainer, PlussBarLogo, PlussBarNav } from '../../components/Eavis/plussBar'
import { navLinks } from './eavis-data'

export default () => (
	<PlussBarContainer>
		<PlussBarLogo>
			<a href="//www.dagbladet.no/pluss">
				<div className="pLogo">
					<svg version="1.1" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
						<g fill="none" fillRule="evenodd">
							<g transform="translate(-592 -202)" fill="#fff">
								<path d="m612.5 213.5h11.5v9h-11.5v11.5h-9v-11.5h-11.5v-9h11.5v-11.5h9v11.5z" />
							</g>
						</g>
					</svg>
				</div>
				<div className="pTitle">Pluss</div>
			</a>
		</PlussBarLogo>
		<PlussBarNav>
			<ul>
				{navLinks.map((item, index) => {
					return (
						<li key={`pluss-nav-li-${index}`}>
							<a href={item.href}>{item.title}</a>
						</li>
					)
				})}
			</ul>
		</PlussBarNav>
	</PlussBarContainer>
)
