import React from 'react'
import { Eavis, BlockHeading } from '../../components/Eavis'
import {
	EavisListContainerWrapper,
	EavisLatestListContainer,
} from '../../components/Eavis/latestBlock'

import EavisIssuesList from '../../components/Eavis/EavisIssuesList'
import { latestList, latestListFeil } from './eavis-data'

export default () => (
	<>
		<Eavis className="eavisMain md-non-visible">
			<EavisListContainerWrapper className={latestList.flexClass}>
				<BlockHeading>{latestList.headingText}</BlockHeading>
				<EavisLatestListContainer>
					<EavisIssuesList issues={latestList.issues} />
				</EavisLatestListContainer>
			</EavisListContainerWrapper>
		</Eavis>
		<Eavis className="eavisMain">
			<EavisListContainerWrapper className={latestListFeil.flexClass}>
				<BlockHeading>{latestListFeil.headingText}</BlockHeading>
				<EavisLatestListContainer>
					<EavisIssuesList issues={latestListFeil.issues} />
				</EavisLatestListContainer>
			</EavisListContainerWrapper>
		</Eavis>
	</>
)
