import React, { createContext, useContext, useReducer, ReactNode } from 'react'

const initialState = {
	articles: [],
}

export const ArticleDispatchContext = createContext({})
const ArticleContext = createContext(initialState)

const articleReducer = (state: any, action: any) => {
	switch (action.type) {
		case 'SET_ARTICLES':
			if (state.articles === action.articles) return state
			return {
				...state,
				articles: action.articles,
			}
		default:
			return state
	}
}

interface Props {
	children: ReactNode
}

const ArticleStoreProvider: React.FC<Props> = ({ children }) => {
	const [state, dispatch] = useReducer(articleReducer, initialState)

	return (
		<ArticleContext.Provider value={state}>
			<ArticleDispatchContext.Provider value={dispatch}>{children}</ArticleDispatchContext.Provider>
		</ArticleContext.Provider>
	)
}
;(ArticleStoreProvider as any).whyDidYouRender = true

export const useArticleStore = () => useContext(ArticleContext)
export const useArticleDispatch = () => useContext(ArticleDispatchContext)

const useArticlesConfig = {
	count: 0,
}

export const useArticles = (numArticlesToGet: number, resetCount?: boolean) => {
	const { articles } = useContext(ArticleContext)

	if (resetCount) {
		useArticlesConfig.count = 0
		return articles
	}

	if (numArticlesToGet === 0) {
		return articles
	}

	if (!articles || (articles && articles.length === 0) || !numArticlesToGet) {
		return []
	}

	const articlesToReturn = articles.slice(
		useArticlesConfig.count,
		useArticlesConfig.count + numArticlesToGet,
	)
	useArticlesConfig.count += numArticlesToGet
	return articlesToReturn
}

export default ArticleStoreProvider
