import fetch from 'isomorphic-unfetch'

export interface HarvesterSearchParams {
	limit?: number
	offset?: string
	q?: string
	includeAnyTags?: string
	includeAllTags?: string
	excludeTags?: string
	includeHosts?: string
	excludeHosts?: string
	startDate?: string
	endDate?: string
	url?: string
	externalId?: string
	excludeUrl?: string
	excludeDupes?: number
	excludePaywall?: string
	excludeExternalId?: string
	includeTagsOccurrence?: string
	tagFields?: string
}

export interface HarvesterItem {
	host: string
	title: string
	url: string
	posted?: string
	fields: HarvesterItemFields
	paywall?: number
}

export interface HarvesterItemFields {
	image?: string
	description?: string
}

export async function fetchHarvester(query: string) {
	try {
		return fetch(`https://harvester-webservice.herokuapp.com/get${query}`).then(async data =>
			data.json(),
		)
	} catch (err) {
		return null
	}
}
