import React, { createContext, useContext, useState, useEffect } from 'react'
import debounce from 'lodash.debounce'

const IsMobileContext = createContext(true)

const IsMobileProvider = ({ children, initialState }: any) => {
	const [isMobile, setState] = useState(initialState)

	const handleResize = debounce(() => {
		if (window.innerWidth <= 480) {
			setState(true)
		} else if (window.innerWidth > 480) {
			setState(false)
		}
	}, 100)

	useEffect(() => {
		handleResize()
		window.addEventListener('resize', handleResize)
		return () => {
			window.removeEventListener('resize', handleResize)
		}
	}, [handleResize])

	return <IsMobileContext.Provider value={isMobile}>{children}</IsMobileContext.Provider>
}

export const useIsMobile = () => useContext(IsMobileContext)

export default IsMobileProvider
