import gql from 'graphql-tag'

export default gql`
	query solXavierArticles(
		$domain: String
		$excludeIDs: [String]
		$frontID: String
		$limit: Int
		$preset: String
	) {
		recommendations {
			articles: sol(
				domain: $domain
				preset: $preset
				excludeIDs: $excludeIDs
				limit: $limit
				frontID: $frontID
			) {
				url
				cleanImage
				title
				preset
				subtitle
				secondaryTitle
				cerebroScore
				backgroundColor
				sectionTag
				fromFront
				dataLabel
			}
		}
	}
`
