import styled, { css } from 'styled-components'
import { getVariable, getColor } from '@aller/shiny/src/utils'
import { FigCaption } from '@aller/shiny/src/atoms/FigCaption'

const VideoDescription = styled(FigCaption)`
	font-size: ${getVariable('uiRegularSize')};
	line-height: ${getVariable('uiRegularLineHeight')};
	font-family: ${getVariable('mainFont')};
`

const VideoPublished = styled.h2`
	font-size: ${getVariable('uiSmallSize')};
	color: ${props => (props.theme.name === 'KK' ? getColor('darkness') : getColor('typeLight'))};
	font-family: ${getVariable('mainFont')};
`

const JWSharedStyles = css`
	&& {
		.jw-nextup-container {
			display: none;
		}
		.jw-controls-backdrop {
			background: transparent;
		}
		.jw-state-idle .jw-controls {
			background: rgba(0, 0, 0, 0.15);
		}
	}
`

export { VideoDescription, VideoPublished, JWSharedStyles }
