import React from 'react'
import PropTypes from 'prop-types'

import Script from '../../Script'

const VideoAssetsScript = () => (
	<Script async={false} id="video-assets-script" src="/static/wf/video-assets.js" />
)

const PlayerLibraryScript = ({ id }) => (
	<Script
		async={false}
		id="jw-player-script"
		src={`https://content.jwplatform.com/libraries/${id}.js`}
	/>
)

const PlayerInitScript = ({ videoId, isSticky, withPrebid, plussproductid }) => {
	if (plussproductid) {
		plussproductid = `"${plussproductid}"`
	}

	return (
		<Script
		code={`
			if (window.player) {
				window.player({ id: '${videoId}', isSticky: ${isSticky}, withPrebid: ${withPrebid}, plussproductid: ${plussproductid} })
			} else {
				window.addEventListener('videoAssetsLoaded', function() {
					window.player({ id: '${videoId}', isSticky: ${isSticky}, withPrebid: ${withPrebid}, plussproductid: ${plussproductid} })
				})
			}`}
		/>
	)
}

PlayerLibraryScript.propTypes = {
	id: PropTypes.string.isRequired,
}

PlayerInitScript.defaultProps = {
	isSticky: false,
	withPrebid: true,
	plussproductid: null
}

PlayerInitScript.propTypes = {
	videoId: PropTypes.string.isRequired,
	isSticky: PropTypes.bool,
	withPrebid: PropTypes.bool,
	plussproductid: PropTypes.string
}

export { PlayerLibraryScript, VideoAssetsScript, PlayerInitScript }
