import React from 'react'
import { VideoPaywall } from '../VideoPaywall'
import VideoPlaceholder from './placeholder'
import { PlayerLibraryScript, VideoAssetsScript, PlayerInitScript } from './scripts'
import { VideoEmbedPropTypes, VideoEmbedDefaultProps } from './prop-types'

const VideoEmbed = ({
	videoId,
	plussproductid,
	image,
	isSticky,
	isIframe,
	playerId,
	doInit,
	withPrebid,
	isEmbedExternally,
}) => {
	return (
		<>
			{/* Actual player */}
			<VideoPlaceholder
				videoId={videoId}
				isSticky={isSticky}
				// if in full video page, let placeholder be black
				image={isEmbedExternally ? image : null}
				isIframe={isIframe}
			/>
			{playerId && <PlayerLibraryScript id={playerId} />}
			<VideoAssetsScript />
			{doInit && (
				<PlayerInitScript
					plussproductid={plussproductid}
					videoId={videoId}
					isSticky={isSticky}
					withPrebid={withPrebid}
				/>
			)}

			{/* Paywall overlay */}
			<VideoPaywall videoId={videoId} product={plussproductid} image={image} />
		</>
	)
}

VideoEmbed.propTypes = VideoEmbedPropTypes

VideoEmbed.defaultProps = VideoEmbedDefaultProps

export { VideoEmbedPropTypes, VideoEmbedDefaultProps }
export default VideoEmbed
