import styled from 'styled-components'

import { JWSharedStyles } from '../styles'

const videoRatio = 56.25

// styling of jw player
// note that we're taking values in px
// because on websites there are different
// font-size in <html> tag, so rem will
// produce different results
export default styled.div`
	&& {
		position: relative;
		background: black; /* black background by default */
		${({ image }) => {
			return image ? `background-image: url('${image}');` : `background-color: black;`
		}}
		background-size: cover;
		padding-bottom: ${videoRatio}%;

		.jw-slider-time {
			padding: 0 12px;
		}

		.jw-nextup-body {
			padding: 8px;
		}

		.jw-title-primary {
			padding-left: 20px;
			padding-right: 20px;
			padding-bottom: 0.5em;
			font-size: 18px;
			line-height: 24px;
		}

		.jw-title {
			padding-top: 20px;
			text-shadow: 0 0 2px black;
		}

		.jw-volume-tip {
			padding: 13px 0 26px;
		}
		${JWSharedStyles}
	}
`
