import React from 'react'
import { FontIcon } from '@aller/shiny/src/atoms/FontIcon'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

// Styled display none because it should
// appear only if video player in sticky
// mode to be able to close sticky player
const StyledButton = styled.button`
	&& {
		position: absolute;
		top: calc(-${getVariable('verticalBase')} / 1.2);
		right: 0;
		background: transparent;
		cursor: pointer;
		display: none;
		border: none;
		padding: 0;
		margin-bottom: calc(${getVariable('verticalBase')} / 5);
		color: ${props => props.theme.colors.darkness};
 :focus {
		outline: none;
	}
`

export default () => (
	<StyledButton className="close-sticky-btn">
		<FontIcon size={1.3} name="close" />
	</StyledButton>
)
