/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import PropTypes from 'prop-types'

import { Link } from '@aller/shiny/src/atoms/Link'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { getColor } from '@aller/shiny/src/utils/get-color'
import JWStyler from './embed/JWStyler'

/**
 * All values are in px here,
 * because this component will be used in labrador
 * and labrador has different rem values for each website
 */

const Main = styled.div`
	background-color: transparent;
	-webkit-font-smoothing: initial;
	display: flex;
	flex-direction: column;
	justify-content: center;
	align-items: center;
	text-align: center;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	color: ${getColor('white')};
	background-image: url(${p => p.image});
	background-size: cover;

	&:before {
		content: '';
		position: absolute;
		top: 0;
		left: 0;
		bottom: 0;
		right: 0;

		// when width of screen is odd, then gradient is not covering all the image
		// https://stackoverflow.com/questions/51850356/chrome-linear-gradient-bugs-when-dealing-with-subpixels
		// so, here is 100.5%
		background-size: 100.5% 100.5%;
		background-image: linear-gradient(
			to bottom,
			rgba(0, 0, 0, 0),
			rgba(0, 0, 0, 0.51) 29%,
			#000000
		);
	}

	a:visited {
		color: ${getColor('white')};
	}

	& * {
		font-family: ${getVariable('mainFont')};
	}
`

const Title = styled.span`
	width: 250px;
	position: relative;
	font-size: 16px;
	line-height: 22px;
	font-style: italic;
	letter-spacing: 0.3px;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		width: 280px;
		font-size: 18px;
	}
`

const CTALink = styled(Link)`
	width: 130px;
	font-size: 14px;
	color: ${getColor('white')};
	padding: 5px 0;
	text-transform: uppercase;
	border-radius: 10px;
	text-decoration: none;
	margin-top: 10px;
	letter-spacing: 1px;
	border: solid 1px rgba(255, 255, 255, 0.6);
	z-index: 1;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		width: 230px;
	}
`

const LoginSection = styled.span`
	opacity: 0.8;
	font-size: 14px;
	position: absolute;
	bottom: 5px;
	right: 10px;
	text-align: right;
`
const LoginLink = styled(Link)`
	color: ${getColor('white')};
	text-decoration: underline;
	text-transform: uppercase;
	padding: 10px 5px;
`
const getPaywallProps = product => {
	switch (product) {
		case 'DBPE':
			return {
				title: 'For å se denne videoen må du ha Dagbladet Pluss-abonnement',
				ctaLink: 'https://www.dagbladet.no/pluss-om',
			}
		case 'SH':
			return {
				title: 'For å se denne videoen må du ha Seher Pluss-abonnement',
				ctaLink: 'https://www.seher.no/cta-seher-subscription-box',
			}
		case 'sol':
			return {
				title: 'For å se denne videoen må du ha Sol Pluss-abonnement',
			}
		case 'EBIL':
			return {
				title: 'For å se denne videoen må du ha Elbil24 Pluss-abonnement',
			}
		case 'VO60':
			return {
				title: 'For å se denne videoen må du ha Vi Pluss-abonnement',
			}
		case 'dinside':
			return {
				title: 'For å se denne videoen må du ha Dinside Pluss-abonnement',
			}
		case 'KK':
			return {
				title: 'For å se denne videoen må du ha KK Pluss-abonnement',
			}
		case 'LOGIN':
			return {
				title: 'Logg inn for å se denne videoen',
				ctaLink: '/app/minside',
				ctaText: 'Logg inn',
				loginSubscription: true,
			}
		default:
			return {
				title: 'Error',
			}
	}
}

const VideoPaywall = ({ image, product, loggedIn, videoId }) => {
	const { title, ctaLink, ctaText, loginSubscription } = getPaywallProps(product)
	const showFooter = !loginSubscription && !loggedIn

	return (
		<JWStyler style={{ display: 'none' }} className={`video-paywall-${videoId}`}>
			<Main image={image} className="overlay" key={0} style={{ display: 'none' }}>
				<Title>{title}</Title>
				{ctaLink && <CTALink href={ctaLink}>{ctaText || 'kjøp nå'}</CTALink>}
				{showFooter && (
					<LoginSection className="paywall-footer">
						Allerede pluss-kunde?
						<LoginLink href="/app/minside">Logg inn her</LoginLink>
					</LoginSection>
				)}
			</Main>
			<Main image={image} className="error" key={1} style={{ display: 'none' }}>
				<Title>Error</Title>
			</Main>
		</JWStyler>
	)
}

VideoPaywall.propTypes = {
	videoId: PropTypes.string.isRequired,
	image: PropTypes.string,
	product: PropTypes.string.isRequired,
	loggedIn: PropTypes.bool,
}

VideoPaywall.defaultProps = {
	loggedIn: false,
	image: null,
}

export { VideoPaywall }
