import React from 'react'
import PropTypes from 'prop-types'
import { createGlobalStyle } from 'styled-components'
import qs from 'query-string'

import JWVideoWidget, { videoWidgetProps } from './widgets/JW'

const Global = createGlobalStyle`
	:root {
		height: 100%;
		width: 100%;
		overflow: hidden;
	}

	.jwplayer {
		max-height: 100vh;
	}
`

/**
 * @function
 * A wrapper that styles iframe specifically
 */
const VideoIframe = props => {
	let autoplay

	if (process.browser) {
		const params = qs.parse(window.location.search)

		if (params.autoplay) {
			autoplay = params.autoplay === 'true'
		}
	}

	const { video } = props
	return (
		<>
			<Global />
			<JWVideoWidget isIframe {...video} autoplay={autoplay} />
		</>
	)
}

VideoIframe.propTypes = {
	video: PropTypes.shape(videoWidgetProps).isRequired,
}

export default VideoIframe
