import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'
import { LinkBarDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import ShinyUserDropDown from '@aller/shiny/src/organisms/UserDropdown'
import { MenuLayer } from '@aller/shiny/src/atoms/MenuLayer'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

import { useUserProvider } from '../../providers/User'

// interface Props {
// 	linkProps: {}
// }

const LogInLink = styled(LinkBarLink)`
	font-family: ${getVariable('headingsFont')};
	font-weight: 500;
	font-style: italic;
	letter-spacing: 0.1rem;
	font-size: 1.6rem;

	span {
		font-size: 1.3rem;
	}
`

const StyledLinkBarDropDown = LogInLink.withComponent(LinkBarDropdown)

const UserDropDown = ({ linkProps }) => {
	const { name, user_id } = useUserProvider() // eslint-disable-line camelcase

	if (!name) {
		return (
			<LogInLink
				size="large"
				href="https://www.kk.no/app/minside"
				{...linkProps}
				inset
				rounded
				ALLCAPS={false}
			>
				Logg inn
			</LogInLink>
		)
	}
	return (
		<StyledLinkBarDropDown {...linkProps} linkText={name}>
			<MenuLayer right={0} width="25rem">
				<ShinyUserDropDown uiSize="small" position="static" user={{ name, user_id }} />
			</MenuLayer>
		</StyledLinkBarDropDown>
	)
}
UserDropDown.propTypes = {
	linkProps: PropTypes.shape({}),
}
UserDropDown.defaultProps = {
	linkProps: {},
}

export default UserDropDown
