import React from 'react'
import styled from 'styled-components'
import dynamic from 'next/dynamic'

import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Header = styled.header`
	margin-bottom: ${getVariable('horizontalBase')};
`
const BrandBar = dynamic(() =>
	import(/* webpackChunkName: "BrandBar" */ './StartComponents/BrandBar'),
)
const StartHeader = () => (
	<Header>
		<BrandBar />
	</Header>
)

export default StartHeader
